package gov.va.med.mhv.util.distributor.message;

import java.util.Map;

/**
 * This is the interface for Responses received when using the Distributor classes.
 *
 */
public class BaseResponse {
	
	protected long executionTime = 0;
	protected String responseBody = "";
	protected int statusCode = 600;
	protected String statusLine = "";
	protected boolean successful = false;
	protected Map<String, ?> properties;
	
	/**
	 * The amount of time for the request to execute
	 * @return
	 */
	public long getExecutionTime() {
		return executionTime;
	}
   
    /**
     * The Map of the properties or property objects returned by the receiving client
     * @return
     */
    public Map<String,?> getProperties() {
    	return properties;
    	}

    /**
     * The response body from the client
     * @return
     */
    public String getResponseBody() {
		return responseBody;
	}
    
    /**
     * Status code returned by the client
     * @return
     */
    public int getStatusCode() {
		return statusCode;
	}
    
    /**
     * The status line returned by the client
     * @return
     */
    public String getStatusLine() {
		return statusLine;
	}
    
    /**
     * Was the distribution of the message successful
     * @return
     */
    public boolean isSuccessful() {
		return successful;
	}

    /**
	 * The amount of time for the request to execute
	 * @return
	 */
	public void setExecutionTime(long executionTime) {
		this.executionTime = executionTime;
	}
   
    /**
     * The Map of the properties or property objects returned by the receiving client
     * @return
     */
    public void setProperties(Map<String,?> properties) {
    	this.properties = properties;
    	}

    /**
     * The response body from the client
     * @return
     */
    public void setResponseBody(String responseBody) {
		this.responseBody = responseBody;
	}
    
    /**
     * Status code returned by the client
     * @return
     */
    public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}
    
    /**
     * The status line returned by the client
     * @return
     */
    public void setStatusLine(String statusLine) {
		this.statusLine = statusLine;
	}
    
    /**
     * Was the distribution of the message successful
     * @return
     */
    public void setSuccessful(boolean successful) {
		this.successful = successful;
	}

}
